#!/bin/bash

set -e

current_dir=$(cd "$(dirname $0)"; pwd -P)
CERT_DIR="${current_dir}/certs"

clean() {
  mkdir -p "${CERT_DIR}"
  # shellcheck disable=SC2115
  rm -rf "${CERT_DIR}"/*
}

# shellcheck disable=SC2002
genCerts() {
  local namespace=$1
  local expireYears=$2
  local operatorYAMLFile=$3
  local expireHours=$(( expireYears * 365 * 24 ))

  echo "====================================="
  echo "will generate certs for namespace: ${namespace} expireYears: ${expireYears}"

  clean
  cd "${CERT_DIR}"
  chmod +x "${current_dir}/renewCerts-linux-amd64"
  "${current_dir}/renewCerts-linux-amd64" --domain "bonree-webhook.${namespace}.svc" --caExpireHours ${expireHours} --tlsExpireHours ${expireHours}
  cd -

  CA_BUNDLE=$(cat "${CERT_DIR}/ca.crt" | base64 | tr -d '\n')
  tls_crt=$(cat "${CERT_DIR}/tls.crt" | base64 | tr -d '\n')
  tls_key=$(cat "${CERT_DIR}/tls.key" | base64 | tr -d '\n')

  echo "====================================="
  echo "caBundle: ${CA_BUNDLE}"
  echo "tls_crt: ${tls_crt}"
  echo "tls_key: ${tls_key}"

  if [ -n "${operatorYAMLFile}" ] && [ -f "${operatorYAMLFile}" ]; then
    echo "====================================="
    echo "will update certs for operatorYAMLFile: ${operatorYAMLFile}"
    sed -i "s/caBundle: .*/caBundle: ${CA_BUNDLE}/" "${operatorYAMLFile}"
    sed -i "s/  tls.crt: .*/  tls.crt: ${tls_crt}/" "${operatorYAMLFile}"
    sed -i "s/  tls.key: .*/  tls.key: ${tls_key}/" "${operatorYAMLFile}"
  fi
}

namespace="$1"
expireYears="$2"
operatorYAMLFile="$3"

genCerts "${namespace:-bonree-agent}" "${expireYears:-10}" "${operatorYAMLFile}"
